'
'  This program uses the system bios and low-level DOS calls to return
' information about the disk drives/disks installed on a computer system.
'
'  Define REGISTER variable type and register variables.
'
TYPE REGISTERS
AX AS INTEGER
BX AS INTEGER
CX AS INTEGER
DX AS INTEGER
BP AS INTEGER
SI AS INTEGER
DI AS INTEGER
FLAGS AS INTEGER
DS AS INTEGER
ES AS INTEGER
END TYPE
DIM INREGS AS REGISTERS,OUTREGS AS REGISTERS,NCLUST AS LONG,ACLUST AS LONG
DIM SPERC AS LONG,BPS AS LONG,FREEDISK AS LONG,DSIZE AS LONG
DIM SERN(1 TO 13) AS INTEGER
'
'  Use interrupt 21 / function 30 to get DOS version.  (Only need major
' version number.)
'
INREGS.AX=&H3000
CALL INTERRUPTX(&H21,INREGS,OUTREGS)
VRS=OUTREGS.AX
VRS=VRS-256*INT(VRS/256+.001)
'
'  Get disk information retrievable from interrupt 21 / function 32 and
' print it to screen.
'
INREGS.AX=&H3200
'
'  DX register stores disk number.  Disk is either specified on command
' line (COMMAND$ variable) upon execution or it defaults to current disk.
'
INREGS.DX=0
D$=COMMAND$
IF LEN(D$)>0 THEN
D$=MID$(UCASE$(LTRIM$(RTRIM$(D$))),1,1)
IF ASC(D$)>=65 AND ASC(D$)<=90 THEN INREGS.DX=ASC(D$)-64
END IF
CALL INTERRUPTX(&H21,INREGS,OUTREGS)
'
'  If AL register is FF, specified drive is invalid.  (Terminate in that
' case.)  (Use subroutine BSEP to get low and high bytes.)
'
CALL BSEP(OUTREGS.AX,AH,AL)
IF AL<>&HFF THEN
'
'  Drive is valid.
'
CLS
'
'  Tell program where data table is stored and then work through table.
' The offset (OS) is updated by 1 or 2 (or 4), depending on how many
' bytes the particular data item takes up.
'
DEF SEG=OUTREGS.DS
OS=OUTREGS.BX
'
'  Save disk number for later call to interrupt 13.
'
DISK=PEEK(OS)
PRINT "DRIVE = ";CHR$(65+DISK)
PRINT
OS=OS+1
PRINT "DEVICE DRIVER UNIT NUMBER = ";PEEK(OS);" (";HEX$(PEEK(OS));"h)"
PRINT
OS=OS+1
BPS=PEEK(OS)+256!*PEEK(OS+1)
PRINT "BYTES PER SECTOR = ";BPS
PRINT
OS=OS+2
SPERC=CLNG(PEEK(OS))+1&
PRINT "SECTORS PER CLUSTER = ";SPERC
PRINT
OS=OS+1
PRINT "SHIFT FACTOR = ";PEEK(OS);" (";HEX$(PEEK(OS));"h)"
PRINT
OS=OS+1
PRINT "# RESERVED BOOT SECTORS = ";PEEK(OS)+256!*PEEK(OS+1)
PRINT
OS=OS+2
PRINT "# FAT COPIES = ";PEEK(OS)
PRINT
OS=OS+1
PRINT "# ROOT DIRECTORY ENTRIES = ";PEEK(OS)+256!*PEEK(OS+1)
PRINT
OS=OS+2
PRINT "FIRST DATA SECTOR NUMBER = ";PEEK(OS)+256!*PEEK(OS+1)
PRINT
OS=OS+2
NCLUST=PEEK(OS)+256&*PEEK(OS+1)-1&
PRINT "NUMBER OF CLUSTERS = ";NCLUST
PRINT
OS=OS+2
'
'  Pause when screen gets full.
'
PRINT
PRINT "Press any key to continue...";
5 IF INKEY$="" THEN GOTO 5
PRINT
PRINT
PRINT
SPF=PEEK(OS)
IF VRS>3 THEN
OS=OS+1
SPF=SPF+256!*PEEK(OS)
END IF
PRINT "SECTORS PER FAT = ";SPF
PRINT
OS=OS+1
PRINT "ROOT DIRECTORY STARTING SECTOR # = ";PEEK(OS)+256!*PEEK(OS+1)
PRINT
OS=OS+2
PRINT "DRIVE'S DEVICE DRIVER ADDRESS = ";HEX$(PEEK(OS+2)+256*PEEK(OS+3));":";
PRINT HEX$(PEEK(OS)+256*PEEK(OS+1))
PRINT
OS=OS+4
'
'  Save media descriptor byte so later call to interrupt 13 can be avoided
' for hard drives.
'
MDB=PEEK(OS)
PRINT "MEDIA DESCRIPTOR BYTE = ";HEX$(MDB);"h"
PRINT
OS=OS+1
A=PEEK(OS)
PRINT "DISK PARAMETER BLOCK VALIDITY BYTE = ";HEX$(A);"h ",;
IF A=&HFF THEN PRINT "(Rebuild.)"
IF A<>&HFF THEN PRINT "(Don't need to rebuild.)"
PRINT
OS=OS+1
PRINT "NEXT DEVICE PARAMETER BLOCK AT ";HEX$(PEEK(OS+2)+256*PEEK(OS+3));":";
PRINT HEX$(PEEK(OS)+256*PEEK(OS+1));"."
PRINT
OS=OS+4
IF VRS=2 THEN
PRINT "STARTING CLUSTER # FOR CURRENT DIRECTORY = ";PEEK(OS)+256!*PEEK(OS+1)
PRINT
OS=OS+2
ASCIIZ$=""
FOR I=1 TO 64
A=PEEK(OS+I-1)
IF A=0 THEN GOTO 10
ASCIIZ$=ASCIIZ$+CHR$(A)
NEXT I
10 PRINT "DISK PATH:  ";ASCIIZ$
ELSEIF VRS>2 THEN
PRINT "CLUSTER AT WHICH TO START SEARCH FOR FREE SPACE = ";
PRINT PEEK(OS)+256!*PEEK(OS+1)
END IF
PRINT
'
'  For DOS versions of at least 4, get disk serial number and FAT type.
' (This information may be meaningless for a floppy disk but I don't
' want to risk making an erroneous test and exclude a valid drive from
' this analysis.)
'
FAT$=""
IF VRS>=4 THEN
PRINT
PRINT "Press any key to continue...";
12 IF INKEY$="" THEN GOTO 12
PRINT
PRINT
INREGS.AX=&H6900
INREGS.BX=0
IF LEN(D$)>0 THEN
D$=MID$(UCASE$(LTRIM$(RTRIM$(D$))),1,1)
IF ASC(D$)>=65 AND ASC(D$)<=90 THEN INREGS.BX=ASC(D$)-64
END IF
OS=VARPTR(SERN(1))
INREGS.DX=OS
SM=VARSEG(SERN(1))
INREGS.DS=SM
CALL INTERRUPTX(&H21,INREGS,OUTREGS)
DEF SEG=SM
DISKR$=HEX$(PEEK(OS+3))+HEX$(PEEK(OS+2))
13 IF LEN(DISKR$)<4 THEN DISKR$="0"+DISKR$ : GOTO 13
DISKL$=HEX$(PEEK(OS+5))+HEX$(PEEK(OS+4))
14 IF LEN(DISKL$)<4 THEN DISKL$="0"+DISKL$ : GOTO 14
PRINT "VOLUME SERIAL NUMBER = ";DISKL$+"-"+DISKR$
PRINT
FOR I=&H11 TO &H18
FAT$=FAT$+CHR$(PEEK(OS+I))
NEXT I
END IF
'
'  If FAT type did not get properly identified (whether because the DOS
' version is less than 4 or some other reason), use value of NCLUST to
' determine FAT type.
'
IF MID$(FAT$,1,3)<>"FAT" THEN FAT$="FAT12" : IF NCLUST>&HFF5 THEN FAT$="FAT16"
PRINT "FAT TYPE = ";FAT$
PRINT
'
'  Get available disk memory.
'
INREGS.AX=&H3600
INREGS.DX=0
IF LEN(D$)>0 THEN
D$=MID$(UCASE$(LTRIM$(RTRIM$(D$))),1,1)
IF ASC(D$)>=65 AND ASC(D$)<=90 THEN INREGS.DX=ASC(D$)-64
END IF
CALL INTERRUPTX(&H21,INREGS,OUTREGS)
ACLUST=CLNG(OUTREGS.BX) : IF ACLUST<0 THEN ACLUST=ACLUST+65536&
FREEDISK=ACLUST*SPERC*BPS
'
'  Read first sector from disk to get formatting program.  (Output name
' of formatting program at end if carry flag isn't set by interrupt call.)
'
'  Need disk size now because call to interrupt 25 depends on it.
'
DSIZE=BPS*SPERC*NCLUST
DIM SECTOR0(1 TO INT((BPS+3)/4+.001)) AS LONG,CF AS INTEGER
INREGS.AX=DISK
IF DSIZE<=32&*1024&^2 THEN
INREGS.BX=VARPTR(SECTOR0(1))
INREGS.CX=1
INREGS.DX=0
INREGS.DS=VARSEG(SECTOR0(1))
ELSE
DIM PACKET(1 TO 5) AS INTEGER
PACKET(1)=0
PACKET(2)=0
PACKET(3)=1
PACKET(4)=VARPTR(SECTOR0(1))
PACKET(5)=VARSEG(SECTOR0(1))
INREGS.BX=VARPTR(PACKET(1))
INREGS.CX=-1
INREGS.DS=VARSEG(PACKET(1))
END IF
CALL INTERRUPTX(&H25,INREGS,OUTREGS)
CF=OUTREGS.FLAGS AND 1%
IF CF=0 THEN
OS=VARPTR(SECTOR0(1))+3
DEF SEG=VARSEG(SECTOR0(1))
FPROG$=""
15 BYTE=PEEK(OS) : OS=OS+1 : IF BYTE<>0 THEN FPROG$=FPROG$+CHR$(BYTE) : GOTO 15
DEF SEG
ELSE
FPROG$="UNKNOWN"
END IF
'
'  Here's that test mentioned earlier regarding the media descriptor byte
' and hard drives.  If hard drive was NOT detected, get drive/disk
' information retrievable from interrupt 13 / function 8.
'
IF MDB=&HF8 THEN GOTO 30
'
'  Just in case F8 is not the only media descriptor byte that some exotic
' hard disk might have, print warning.
'
PRINT
PRINT "(The following information may be meaningless for a hard disk.)"
PRINT
PRINT "Press any key to continue...";
16 IF INKEY$="" THEN GOTO 16
PRINT
PRINT
PRINT
INREGS.AX=&H800
'
'  DX register again stores disk number.  (Disk is referenced differently
' here--it's zero based now, as it was on the output of the call to
' interrupt 21.)
'
INREGS.DX=DISK
CALL INTERRUPTX(&H13,INREGS,OUTREGS)
'
'  Some of the outputs of this interrupt are in the registers.  Others
' are in a table.
'
CALL BSEP(OUTREGS.DX,DH,DL)
CALL BSEP(OUTREGS.CX,CH,CL)
CALL BSEP(OUTREGS.BX,BH,BL)
IF BL=1 THEN PRINT "5.25";CHR$(34);", 360K, 40 TRACKS"
IF BL=2 THEN PRINT "5.25";CHR$(34);", 1.2M, 80 TRACKS"
IF BL=3 THEN PRINT "3.5";CHR$(34);", 720K, 80 TRACKS"
IF BL=4 THEN PRINT "3.5";CHR$(34);", 1.44M, 80 TRACKS"
PRINT
PRINT "NUMBER OF TRACKS PER SIDE = ";CH+1
PRINT
PRINT "NUMBER OF SECTORS PER TRACK = ";CL
PRINT
PRINT "NUMBER OF SIDES = ";DH+1
PRINT
PRINT "NUMBER OF CONSECUTIVE DRIVES ATTACHED = ";DL+1
PRINT
'
'  Point program to above mentioned table.  Offset (OS) is updated by 1
' since each data item is only one byte.
'
DEF SEG=OUTREGS.ES
OS=OUTREGS.DI
PRINT "FIRST SPECIFY BYTE = ";HEX$(PEEK(OS));"h"
PRINT
OS=OS+1
PRINT "SECOND SPECIFY BYTE = ";HEX$(PEEK(OS));"h"
PRINT
OS=OS+1
PRINT "NUMBER OF TIMER TICKS TO WAIT BEFORE TURNING OFF DRIVE MOTOR = ";PEEK(OS)
PRINT
OS=OS+1
PRINT "BYTES PER SECTOR (FROM TABLE) = ";128*2^PEEK(OS)
PRINT
OS=OS+1
PRINT "SECTORS PER TRACK (FROM TABLE) = ";PEEK(OS)
PRINT
OS=OS+1
PRINT
PRINT "Press any key to continue...";
25 IF INKEY$="" THEN GOTO 25
PRINT
PRINT
PRINT
PRINT "GAP LENGTH = ";PEEK(OS)
PRINT
OS=OS+1
PRINT "DATA LENGTH = ";PEEK(OS)
PRINT
OS=OS+1
PRINT "GAP LENGTH FOR FORMAT = ";PEEK(OS)
PRINT
OS=OS+1
PRINT "FILL BYTE FOR FORMAT = ";HEX$(PEEK(OS));"h"
PRINT
OS=OS+1
PRINT "HEAD SETTLE TIME (ms) = ";PEEK(OS)
PRINT
OS=OS+1
PRINT "MOTOR START UP TIME (in 1/8th seconds) = ";PEEK(OS)
PRINT
'
'  Output disk size and available space.
'
30 PRINT "DISK SIZE = ";LTRIM$(RTRIM$(STR$(DSIZE)));" BYTES"
PRINT
PRINT "(";LTRIM$(RTRIM$(STR$(FREEDISK)));" BYTES FREE.)"
PRINT
PRINT "Disk formatted with ";FPROG$;"."
ELSE
PRINT
PRINT "SHAME ON YOU!  THAT DRIVE'S INVALID."
END IF
END
'
'  This subroutine inputs a 2-byte integer and returns its low and high
' bytes.
'
SUB BSEP(VALUE AS INTEGER,HIGH,LOW)
LOW=VALUE AND &HFF
HIGH=CSNG(((VALUE AND &HFF00)/256+256) MOD 256)
END SUB
